/************************************************************************
 *
 * \file: DemoFactories.cpp
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto - Demo application
 *
 * \author: J. Harder / ADITG/SW1 / jharder@de.adit-jv.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#include <adit_logging.h>
#include <aauto_macros.h>
#include <aauto/AautoLogging.h>

#include <aauto/AditVideoSink.h>
#include <aauto/AditAudioSink.h>
#include <aauto/AditAudioSource.h>
#include <aauto/AditInputSource.h>
#include <aauto/AditMediaPlaybackStatus.h>
#include <aauto/AditMediaBrowser.h>
#include <aauto/AditNavigationStatus.h>
#include <aauto/AditSensorSource.h>

#include "DemoFactory.h"

LOG_IMPORT_CONTEXT(demo)

namespace adit { namespace aauto {

bool DemoFactory::staticRegister(const char* inName, FactoryImplementationType inType,
        CreatorFn inCreator)
{
    switch (inType)
    {
    case FactoryVideoSink:
        return DemoFactory::instance().registerImpl<AditVideoSink, VideoSinkCreatorFn>(inName,
                reinterpret_cast<VideoSinkCreatorFn>(inCreator));
    case FactoryAudioSink:
        return DemoFactory::instance().registerImpl<AditAudioSink, AudioSinkCreatorFn>(
                inName, reinterpret_cast<AudioSinkCreatorFn>(inCreator));
    case FactoryAudioSource:
        return DemoFactory::instance().registerImpl<AditAudioSource, AudioSourceCreatorFn>(
                inName, reinterpret_cast<AudioSourceCreatorFn>(inCreator));
    case FactoryInputSource:
        return DemoFactory::instance().registerImpl<AditInputSource, InputSourceCreatorFn>(
                inName, reinterpret_cast<InputSourceCreatorFn>(inCreator));
    case FactoryMediaPlaybackStatus:
        return DemoFactory::instance().registerImpl<AditMediaPlaybackStatus, MediaPlaybackStatusCreatorFn>(
                inName, reinterpret_cast<MediaPlaybackStatusCreatorFn>(inCreator));
    case FactoryMediaBrowser:
        return DemoFactory::instance().registerImpl<AditMediaBrowser, MediaBrowserCreatorFn>(
                inName, reinterpret_cast<MediaBrowserCreatorFn>(inCreator));
    case FactoryNavigationStatus:
        return DemoFactory::instance().registerImpl<AditNavigationStatus, NavigationStatusCreatorFn>(
                inName, reinterpret_cast<NavigationStatusCreatorFn>(inCreator));
    case FactorySensorSource:
        return DemoFactory::instance().registerImpl<AditSensorSource, SensorSourceCreatorFn>(
                inName, reinterpret_cast<SensorSourceCreatorFn>(inCreator));
    default:
        LOG_ERROR((demo, "%d is not a valid factory implementation type", (int)inType));
        return false;
    }
}

} } // namespace adit { namespace aauto {
